output "event_stream_arn" {
  value = "${aws_kinesis_stream.event_stream.arn}"
}

output "event_stream_name" {
  value = "${aws_kinesis_stream.event_stream.name}"
}

output "events_table_arn" {
  value = "${aws_dynamodb_table.events_table.arn}"
}

output "events_table_name" {
  value = "${aws_dynamodb_table.events_table.id}"
}

output "projects_table_arn" {
  value = "${aws_dynamodb_table.projects_table.arn}"
}

output "projects_table_name" {
  value = "${aws_dynamodb_table.projects_table.id}"
}

output "ingest_queue_arn" {
  value = "${aws_sqs_queue.ingest_queue.arn}"
}

output "ingest_queue_name" {
  value = "${var.name}-${var.environment}-ingest"
}

output "s3_bucket_arn" {
  value = "${aws_s3_bucket.s3_bucket.arn}"
}

output "s3_bucket_name" {
  value = "${aws_s3_bucket.s3_bucket.id}"
}

output "event_store_lambda_name" {
  value = "${var.name}-${var.environment}"
}

output "memcached_configuration_endpoint" {
  value = "${aws_elasticache_cluster.memcached.configuration_endpoint}"
}

output "memcached_cluster_address" {
  value = "${aws_elasticache_cluster.memcached.cluster_address}"
}
