variable "name" {
  description = "Service name used for AWS tagging among other things. #REQUIRED"
}

variable "project" {
  description = "Project name, usually git repo. ex. dta/twitch-create-service. #REQUIRED"
}

variable "environment" {
  description = "Service environment. #REQUIRED"
}

variable "owner" {
  description = "Team email alias. #REQUIRED"
}

variable "subnet_ids" {
  default     = ""
  description = "Comma separated list of subnet IDs. Leave empty to use default VPC and subnets."
}

variable "security_groups" {
  default     = ""
  description = "Comma separated list of security group IDs. Leave empty to use default VPC and security groups."
}

variable "account_id" {
  default     = ""
  description = "AWS Account ID."
}

variable "projects_table_read_capacity" {
  description = "Read capacity for projects DynamoDB table. #REQUIRED"
}

variable "projects_table_write_capacity" {
  description = "Write capacity for projects DynamoDB table. #REQUIRED"
}

variable "events_table_read_capacity" {
  description = "Read capacity for events DynamoDB table. #REQUIRED"
}

variable "events_table_write_capacity" {
  description = "Write capacity for events DynamoDB table. #REQUIRED"
}

variable "eventtype_gsi_read_capacity" {
  description = "Read capacity for EventTypeIndex DynamoDB Global Secondary Index. #REQUIRED"
}

variable "eventtype_gsi_write_capacity" {
  description = "Write capacity for EventTypeIndex DynamoDB Global Secondary Index. #REQUIRED"
}

variable "memcached_cluster_name" {
  default     = ""
  description = "Name given to the memcached cluster. Defaults to name-environment."
}

# dynamic variables
resource "null_resource" "vars" {
  triggers {
    default_memcache_cluster_name = "${var.name}-${var.environment}"
  }
}
