# The Elastic Beanstalk app will have several environments within it.
resource "aws_elastic_beanstalk_application" "eb_app" {
  name        = "${var.name}"
  description = "${var.name}"
}

resource "aws_api_gateway_rest_api" "github_webhook_handler_api" {
  name        = "${var.rest_api_name}"
  description = "Receiver of GitHub webhooks"
}

resource "aws_api_gateway_deployment" "github_webhook_handler_deployment" {
  depends_on  = ["aws_api_gateway_integration.test"]
  rest_api_id = "${aws_api_gateway_rest_api.github_webhook_handler_api.id}"
  stage_name  = "${var.deployment_name}"
}

resource "aws_api_gateway_resource" "test" {
  rest_api_id = "${aws_api_gateway_rest_api.github_webhook_handler_api.id}"
  parent_id   = "${aws_api_gateway_rest_api.github_webhook_handler_api.root_resource_id}"
  path_part   = "test"
}

resource "aws_api_gateway_method" "test-get" {
  rest_api_id   = "${aws_api_gateway_rest_api.github_webhook_handler_api.id}"
  resource_id   = "${aws_api_gateway_resource.test.id}"
  http_method   = "GET"
  authorization = "NONE"
}

resource "aws_api_gateway_method_response" "test-get-200" {
  rest_api_id = "${aws_api_gateway_rest_api.github_webhook_handler_api.id}"
  resource_id = "${aws_api_gateway_resource.test.id}"
  http_method = "${aws_api_gateway_method.test-get.http_method}"
  status_code = "200"
}

resource "aws_api_gateway_integration" "test" {
  rest_api_id = "${aws_api_gateway_rest_api.github_webhook_handler_api.id}"
  resource_id = "${aws_api_gateway_resource.test.id}"
  http_method = "${aws_api_gateway_method.test-get.http_method}"
  type        = "MOCK"

  # Transforms the incoming XML request to JSON
  request_templates {
    "application/json" = <<EOF
{
   "body": $input.json('$'),
   "statusCode": 200
}
EOF
  }
}

resource "aws_api_gateway_integration_response" "test" {
  rest_api_id = "${aws_api_gateway_rest_api.github_webhook_handler_api.id}"
  resource_id = "${aws_api_gateway_resource.test.id}"
  http_method = "${aws_api_gateway_method.test-get.http_method}"
  status_code = "${aws_api_gateway_method_response.test-get-200.status_code}"

  # Transforms the backend JSON response to XML
  response_templates {
    "application/json" = "$input.path('$')"
  }
}

resource "aws_api_gateway_resource" "webhook" {
  rest_api_id = "${aws_api_gateway_rest_api.github_webhook_handler_api.id}"
  parent_id   = "${aws_api_gateway_rest_api.github_webhook_handler_api.root_resource_id}"
  path_part   = "webhook"
}
