resource "aws_iam_role" "bs" {
  name = "${null_resource.vars.triggers.cn}"
  path = "/"

  assume_role_policy = <<EOT
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Principal": { "Service": "ec2.amazonaws.com"},
      "Action": "sts:AssumeRole"
    }
  ]
}
EOT
}

resource "aws_iam_instance_profile" "bs" {
  depends_on = ["aws_iam_role.bs"]
  name       = "${null_resource.vars.triggers.cn}"
  roles      = ["${aws_iam_role.bs.name}"]
}

resource "aws_iam_role_policy_attachment" "AWSElasticBeanstalkWebTier" {
  role       = "${aws_iam_role.bs.name}"
  policy_arn = "arn:aws:iam::aws:policy/AWSElasticBeanstalkWebTier"
}

resource "aws_iam_role_policy_attachment" "AWSElasticBeanstalkMulticontainerDocker" {
  role       = "${aws_iam_role.bs.name}"
  policy_arn = "arn:aws:iam::aws:policy/AWSElasticBeanstalkMulticontainerDocker"
}

resource "aws_iam_role_policy_attachment" "CloudWatchLogsFullAccess" {
  role       = "${aws_iam_role.bs.name}"
  policy_arn = "arn:aws:iam::aws:policy/CloudWatchLogsFullAccess"
}

resource "aws_iam_role_policy" "bs" {
  name   = "${null_resource.vars.triggers.cn}"
  policy = "${data.aws_iam_policy_document.iam_role_policy.json}"
  role   = "${aws_iam_role.bs.id}"
}

data "aws_iam_policy_document" "iam_role_policy" {
  statement {
    actions = [
      "dynamodb:BatchGetItem",
      "dynamodb:GetItem",
      "dynamodb:PutItem",
      "dynamodb:Query",
      "dynamodb:Scan",
    ]

    resources = [
      "${var.events_table_arn}*",
      "${var.projects_table_arn}*",
    ]
  }

  statement {
    actions = [
      "sts:AssumeRole",
    ]

    resources = [
      "${var.sandstorm_role_arn}",
    ]
  }

  statement {
    actions = [
      "sqs:GetQueueUrl",
      "sqs:ReceiveMessage",
      "sqs:DeleteMessage",
    ]

    resources = [
      "${var.ingest_queue_arn}",
    ]
  }
}
