# Define the different EB environments.
# This app will run in a Docker container and also potentially have other colocated containers.
resource "aws_elastic_beanstalk_environment" "bs" {
  name                = "${null_resource.vars.triggers.cn}"
  description         = "${null_resource.vars.triggers.cn}"
  application         = "${var.eb_application_name}"
  solution_stack_name = "${var.solution_stack_name}"
  tier                = "WebServer"

  tags {
    Name        = "${null_resource.vars.triggers.cn}"
    Environment = "${var.environment}"
    Service     = "${var.project}"
    Owner       = "${var.owner}"
  }

  # Vpc  and network related settings
  setting {
    namespace = "aws:ec2:vpc"
    name      = "VPCId"
    value     = "${var.vpc_id}"
  }

  setting {
    namespace = "aws:ec2:vpc"
    name      = "Subnets"
    value     = "${var.subnet_ids}"
  }

  setting {
    namespace = "aws:ec2:vpc"
    name      = "ELBSubnets"
    value     = "${var.subnet_ids}"
  }

  setting {
    namespace = "aws:ec2:vpc"
    name      = "AssociatePublicIpAddress"
    value     = "false"
  }

  setting {
    namespace = "aws:ec2:vpc"
    name      = "ELBScheme"
    value     = "internal"
  }

  # General Bean Stalk Settings
  setting {
    namespace = "aws:elasticbeanstalk:command"
    name      = "IgnoreHealthCheck"
    value     = "${var.ignore_health_check}"
  }

  # Load Balancer Related Settings
  setting {
    namespace = "aws:elb:loadbalancer"
    name      = "CrossZone"
    value     = "true"
  }

  setting {
    namespace = "aws:elb:loadbalancer"
    name      = "SecurityGroups"
    value     = "${var.security_groups}"
  }

  # elb listener settings for port 80
  setting {
    namespace = "aws:elb:listener:80"
    name      = "ListenerProtocol"
    value     = "TCP"
  }

  setting {
    namespace = "aws:elb:listener:80"
    name      = "InstancePort"
    value     = "80"
  }

  setting {
    namespace = "aws:elb:listener:80"
    name      = "InstanceProtocol"
    value     = "TCP"
  }

  setting {
    namespace = "aws:elb:listener:80"
    name      = "ListenerEnabled"
    value     = "true"
  }

  # elb listener settings for port 443
  setting {
    namespace = "aws:elb:listener:443"
    name      = "ListenerProtocol"
    value     = "HTTPS"
  }

  setting {
    namespace = "aws:elb:listener:443"
    name      = "InstancePort"
    value     = "80"
  }

  setting {
    namespace = "aws:elb:listener:443"
    name      = "InstanceProtocol"
    value     = "HTTP"
  }

  setting {
    namespace = "aws:elb:listener:443"
    name      = "ListenerEnabled"
    value     = "true"
  }

  setting {
    namespace = "aws:elb:listener:443"
    name      = "SSLCertificateId"
    value     = "${var.ssl_certificate_arn}"
  }

  # elb listener settings for port 8080
  setting {
    namespace = "aws:elb:listener:8080"
    name      = "ListenerProtocol"
    value     = "HTTP"
  }

  setting {
    namespace = "aws:elb:listener:8080"
    name      = "InstancePort"
    value     = "8080"
  }

  setting {
    namespace = "aws:elb:listener:8080"
    name      = "InstanceProtocol"
    value     = "HTTP"
  }

  setting {
    namespace = "aws:elb:listener:8080"
    name      = "ListenerEnabled"
    value     = "true"
  }

  # elb policy settings
  setting {
    namespace = "aws:elb:policies"
    name      = "ConnectionDrainingEnabled"
    value     = "true"
  }

  # asg settings
  setting {
    namespace = "aws:autoscaling:asg"
    name      = "Availability Zones"
    value     = "Any 2"
  }

  setting {
    namespace = "aws:autoscaling:asg"
    name      = "MinSize"
    value     = "${var.min_size}"
  }

  setting {
    namespace = "aws:autoscaling:asg"
    name      = "MaxSize"
    value     = "${var.max_size}"
  }

  # asg launch configuration settings
  setting {
    namespace = "aws:autoscaling:launchconfiguration"
    name      = "IamInstanceProfile"
    value     = "${aws_iam_instance_profile.bs.name}"
  }

  setting {
    namespace = "aws:autoscaling:launchconfiguration"
    name      = "EC2KeyName"
    value     = "${var.key_pair}"
  }

  setting {
    namespace = "aws:autoscaling:launchconfiguration"
    name      = "InstanceType"
    value     = "${var.instance_type}"
  }

  setting {
    namespace = "aws:autoscaling:launchconfiguration"
    name      = "SecurityGroups"
    value     = "${var.security_groups}"
  }

  # asg rolling update policy settings
  setting {
    namespace = "aws:autoscaling:updatepolicy:rollingupdate"
    name      = "RollingUpdateType"
    value     = "Health"
  }

  setting {
    namespace = "aws:autoscaling:updatepolicy:rollingupdate"
    name      = "RollingUpdateEnabled"
    value     = "true"
  }

  # Extra environment vars passed into the docker container.
  setting {
    namespace = "aws:elasticbeanstalk:application:environment"
    name      = "APPLICATION_NAME"
    value     = "${var.eb_application_name}"
  }

  setting {
    namespace = "aws:elasticbeanstalk:application:environment"
    name      = "ROLLBAR_TOKEN"
    value     = "${var.rollbar_token}"
  }

  setting {
    namespace = "aws:elasticbeanstalk:application:environment"
    name      = "ENVIRONMENT"
    value     = "${var.environment}"
  }

  setting {
    namespace = "aws:elasticbeanstalk:application:environment"
    name      = "AWS_REGION"
    value     = "us-west-2"
  }

  setting {
    namespace = "aws:elasticbeanstalk:application:environment"
    name      = "EVENTS_TABLE_NAME"
    value     = "${var.events_table_name}"
  }

  setting {
    namespace = "aws:elasticbeanstalk:application:environment"
    name      = "PROJECTS_TABLE_NAME"
    value     = "${var.projects_table_name}"
  }

  setting {
    namespace = "aws:elasticbeanstalk:application:environment"
    name      = "SANDSTORM_ROLE_ARN"
    value     = "${var.sandstorm_role_arn}"
  }

  setting {
    namespace = "aws:elasticbeanstalk:application:environment"
    name      = "INGEST_QUEUE_NAME"
    value     = "${var.ingest_queue_name}"
  }

  setting {
    namespace = "aws:elasticbeanstalk:application:environment"
    name      = "GITHUB_WEBHOOK_URL"
    value     = "${var.github_webhook_url}"
  }

  setting {
    namespace = "aws:elasticbeanstalk:application:environment"
    name      = "MEMCACHED_CONFIG_ENDPOINT"
    value     = "${var.memcached_config_endpoint}"
  }

  setting {
    namespace = "aws:elasticbeanstalk:application:environment"
    name      = "DISABLED_METRICS"
    value     = "${var.disabled_metrics}"
  }

  # eb CloudWatch logging
  setting {
    namespace = "aws:elasticbeanstalk:cloudwatch:logs"
    name      = "StreamLogs"
    value     = "true"
  }

  setting {
    namespace = "aws:elasticbeanstalk:cloudwatch:logs"
    name      = "DeleteOnTerminate"
    value     = "true"
  }

  # eb environment settings
  setting {
    namespace = "aws:elasticbeanstalk:environment"
    name      = "ServiceRole"
    value     = "aws-elasticbeanstalk-service-role"
  }

  # Health reporting system  settings
  setting {
    namespace = "aws:elasticbeanstalk:healthreporting:system"
    name      = "SystemType"
    value     = "enhanced"
  }

  # eb managed updates
  setting {
    namespace = "aws:elasticbeanstalk:managedactions"
    name      = "ManagedActionsEnabled"
    value     = "true"
  }

  setting {
    namespace = "aws:elasticbeanstalk:managedactions"
    name      = "PreferredStartTime"
    value     = "Wed:17:00"                           # 10AM PDT
  }

  setting {
    namespace = "aws:elasticbeanstalk:managedactions:platformupdate"
    name      = "UpdateLevel"
    value     = "minor"
  }

  # eb monitoring settings
  setting {
    namespace = "aws:elasticbeanstalk:monitoring"
    name      = "Automatically Terminate Unhealthy Instances"
    value     = "${var.terminate_unhealthy_instances}"
  }

  # eb notification settings
  setting {
    namespace = "aws:elasticbeanstalk:sns:topics"
    name      = "Notification Protocol"
    value     = "email"
  }

  setting {
    namespace = "aws:elasticbeanstalk:sns:topics"
    name      = "Notification Endpoint"
    value     = "${var.notification_email}"
  }
}
