variable "name" {
  description = "Service name used for AWS tagging among other things. #REQUIRED"
}

variable "environment" {
  description = "Service environment. #REQUIRED"
}

variable "owner" {
  description = "Team email alias. #REQUIRED"
}

variable "project" {
  description = "All lower­case, team/service. #REQUIRED"
}

variable "eb_application_name" {
  description = "Name of an existing beanstalk application. #REQUIRED"
}

variable "events_table_name" {
  description = "Name of the events DynamoDB table. #REQUIRED"
}

variable "events_table_arn" {
  description = "ARN of the events DynamoDB table. #REQUIRED"
}

variable "projects_table_name" {
  description = "Name of the projects DynamoDB table. #REQUIRED"
}

variable "projects_table_arn" {
  description = "ARN of the projects DynamoDB table. #REQUIRED"
}

variable "sandstorm_role_arn" {
  description = "ARN of sandstorm role. #REQUIRED"
}

variable "ingest_queue_name" {
  description = "Name of the ingest SQS queue. #REQUIRED"
}

variable "ingest_queue_arn" {
  description = "ARN of the ingest SQS queue. #REQUIRED"
}

variable "instance_type" {
  description = "EC2 Instance Type."
  default     = "c3.large"
}

variable "max_size" {
  description = "Largest a service cluster will grow to."
  default     = 5
}

variable "min_size" {
  description = "Smallest a service cluster will shrink down to."
  default     = 2
}

variable "solution_stack_name" {
  description = "The Elastic Beanstalk solution name, kind of like an AMI for EB."
  default     = "64bit Amazon Linux 2017.09 v2.8.3 running Multi-container Docker 17.06.2-ce (Generic)"
}

variable "vpc_id" {
  default = ""
}

variable "subnet_ids" {
  default = ""
}

variable "security_groups" {
  default = ""
}

variable "key_pair" {
  description = "Key pair to associate with the EC2 instances."
  default     = "devtools-dta"
}

variable "ssl_certificate_arn" {
  description = "ARN of SSL certificate to use for the https port on the load balancer."
  default     = "arn:aws:iam::043714768218:server-certificate/internal-justin-tv"
}

variable "ignore_health_check" {
  description = "Do not cancel a deployment due to failed health checks."
  default     = "false"
}

variable "terminate_unhealthy_instances" {
  description = "Terminate an instance if it fails health checks."
  default     = "true"
}

variable "github_webhook_url" {
  description = "URL of the GitHub webhook. #REQUIRED"
}

variable "rollbar_token" {
  description = "Sets ROLLBAR_TOKEN env var for reporting crashes into Rollbar."
  default     = ""
}

variable "notification_email" {
  description = "Where to send environment status change notifications."
  default     = ""
}

variable "memcached_config_endpoint" {
  description = "Address of the memcached cluster configuration endpoint. #REQUIRED."
}

variable "disabled_metrics" {
  description = "Comma separated list of metrics that should be disabled."
  default     = ""
}

# dynamic variables
resource "null_resource" "vars" {
  triggers {
    cn = "${var.name}-${var.environment}"
  }
}
