# Give the role access to the kinesis stream.
resource "aws_iam_role_policy" "kinesis_policy" {
  name   = "${var.name}-${var.environment}-github-kinesis"
  policy = "${data.aws_iam_policy_document.iam_role_policy.json}"
  role   = "${module.github_webhook_lambda_app.role_id}"
}

data "aws_iam_policy_document" "iam_role_policy" {
  statement {
    actions = [
      "kinesis:PutRecord",
    ]

    resources = [
      "${var.event_stream_arn}",
    ]
  }

  statement {
    actions = [
      "s3:ListAllMyBuckets",
      "s3:GetBucketLocation",
      "s3:ListBucket",
    ]

    resources = [
      "${var.large_events_s3_bucket_arn}",
    ]
  }

  statement {
    actions = [
      "s3:PutObject",
      "s3:PutObjectAcl",
    ]

    resources = [
      "${var.large_events_s3_bucket_arn}/*",
    ]
  }
}

resource "aws_lambda_permission" "asg_event-slack-slash" {
  function_name = "${module.github_webhook_lambda_app.arn}"

  statement_id = "allow-api-gateway-parent-resource-get"
  action       = "lambda:InvokeFunction"
  principal    = "apigateway.amazonaws.com"

  source_arn = "arn:aws:execute-api:${var.aws_region}:${var.account_id}:${var.github_webhook_handler_rest_api_id}/*/${aws_api_gateway_method.webhook-post.http_method}${aws_api_gateway_resource.webhook.path}"
}
