# Lambda function that subscribes to the kinesis stream and writes events to the
# events table.
module "github_webhook_lambda_app" {
  source                        = "git::git+ssh://git@git-aws.internal.justin.tv/dta/tf_lambda_app.git?ref=1.4.1"
  owner                         = "${var.owner}"
  repository                    = "${var.project}"
  environment                   = "${var.environment}"
  principal                     = "${var.account_id}"
  lambda_handler                = "github_webhook_handler.lambda_handler"
  lambda_function_name          = "${var.name}-${var.environment}-github"
  lambda_description            = "Receives webhooks from GitHub to ingest into RockPaperScissors."
  lambda_runtime                = "python2.7"
  aws_region                    = "${var.aws_region}"
  lambda_vpc_subnet_ids         = "${var.subnet_ids}"
  lambda_vpc_security_group_ids = "${var.security_groups}"
  lambda_timeout                = "60"
}

resource "aws_api_gateway_resource" "webhook" {
  rest_api_id = "${var.github_webhook_handler_rest_api_id}"
  parent_id   = "${var.github_webhook_handler_resource_id}"
  path_part   = "${var.environment}"
}

resource "aws_api_gateway_method" "webhook-post" {
  rest_api_id   = "${var.github_webhook_handler_rest_api_id}"
  resource_id   = "${aws_api_gateway_resource.webhook.id}"
  http_method   = "POST"
  authorization = "NONE"
}

resource "aws_api_gateway_method_response" "webhook-post-200" {
  rest_api_id = "${var.github_webhook_handler_rest_api_id}"
  resource_id = "${aws_api_gateway_resource.webhook.id}"
  http_method = "${aws_api_gateway_method.webhook-post.http_method}"

  status_code = "200"
}

resource "aws_api_gateway_integration" "webhook" {
  rest_api_id = "${var.github_webhook_handler_rest_api_id}"
  resource_id = "${aws_api_gateway_resource.webhook.id}"
  http_method = "${aws_api_gateway_method.webhook-post.http_method}"

  type                    = "AWS_PROXY"
  uri                     = "arn:aws:apigateway:${var.aws_region}:lambda:path/2015-03-31/functions/${module.github_webhook_lambda_app.arn}/invocations"
  integration_http_method = "POST"
}

resource "aws_api_gateway_integration_response" "webhook" {
  depends_on  = ["aws_api_gateway_method_response.webhook-post-200"]
  rest_api_id = "${var.github_webhook_handler_rest_api_id}"
  resource_id = "${aws_api_gateway_resource.webhook.id}"
  http_method = "${aws_api_gateway_method.webhook-post.http_method}"
  status_code = "${aws_api_gateway_method_response.webhook-post-200.status_code}"

  response_templates = {
    "application/json" = ""
  }
}
