variable "name" {
  description = "Service name used for AWS tagging among other things. #REQUIRED"
}

variable "project" {
  description = "Project name, usually git repo. ex. dta/twitch-create-service. #REQUIRED"
}

variable "environment" {
  description = "Service environment. #REQUIRED"
}

variable "owner" {
  description = "Team email alias. #REQUIRED"
}

variable "event_stream_arn" {
  description = "ARN of the events Kinesis stream. #REQUIRED"
}

variable "aws_region" {
  default     = "us-west-2"
  description = "AWS region to operate in"
}

variable "subnet_ids" {
  default     = ""
  description = "Comma separated list of subnet IDs. Leave empty to use default VPC and subnets."
}

variable "security_groups" {
  default     = ""
  description = "Comma separated list of security group IDs. Leave empty to use default VPC and security groups."
}

variable "github_webhook_handler_rest_api_id" {
  description = "ID of the GitHub Webhook Handler REST API. #REQUIRED"
}

variable "github_webhook_handler_deployment_name" {
  description = "Name of the GitHub Webhook Handler Deployment (stage). #REQUIRED"
}

variable "github_webhook_handler_resource_id" {
  description = "ID of the Base GitHub Webhook Handler Resource. #REQUIRED"
}

variable "account_id" {
  description = "AWS Account ID. #REQUIRED"
}

variable "large_events_s3_bucket_arn" {
  description = "ARN of S3 Bucket where large events will be stored. #REQUIRED"
}
