variable "name" {
  description = "Service name used for AWS tagging among other things. #REQUIRED"
}

variable "project" {
  description = "Project name, usually git repo. ex. dta/twitch-create-service. #REQUIRED"
}

variable "environment" {
  description = "Service environment. #REQUIRED"
}

variable "owner" {
  description = "Team email alias. #REQUIRED"
}

variable "event_stream_arn" {
  description = "ARN of the events Kinesis stream. #REQUIRED"
}

variable "ingest_queue_arn" {
  description = "ARN of ingest SQS queue. #REQUIED"
}

variable "aws_region" {
  default     = "us-west-2"
  description = "AWS region to operate in"
}

variable "subnet_ids" {
  default     = ""
  description = "Comma separated list of subnet IDs. Leave empty to use default VPC and subnets."
}

variable "security_groups" {
  default     = ""
  description = "Comma separated list of security group IDs. Leave empty to use default VPC and security groups."
}

variable "account_id" {
  default     = ""
  description = "AWS Account ID."
}
