# Give the role access to the kinesis stream.
resource "aws_iam_role_policy" "kinesis_policy" {
  name   = "${var.name}-${var.environment}-jira-kinesis"
  policy = "${data.aws_iam_policy_document.iam_role_policy.json}"
  role   = "${module.jira_scraper_lambda_app.role_id}"
}

data "aws_iam_policy_document" "iam_role_policy" {
  statement {
    actions = [
      "kinesis:PutRecord",
    ]

    resources = [
      "${var.event_stream_arn}",
    ]
  }

  statement {
    actions = [
      "sts:AssumeRole",
    ]

    resources = [
      "${var.sandstorm_role_arn}",
    ]
  }

  statement {
    actions = [
      "lambda:InvokeFunction",
    ]

    resources = [
      "${aws_cloudwatch_event_rule.jira_scraper_event_rule.arn}",
    ]
  }
}
