# Lambda function that subscribes to the kinesis stream and writes events to the
# events table.
module "jira_scraper_lambda_app" {
  source                        = "git::git+ssh://git@git-aws.internal.justin.tv/dta/tf_lambda_app.git?ref=1.4.1"
  owner                         = "${var.owner}"
  repository                    = "${var.project}"
  environment                   = "${var.environment}"
  principal                     = "${var.account_id}"
  lambda_handler                = "jira_scraper.lambda_handler"
  lambda_function_name          = "${var.name}-${var.environment}-jira"
  lambda_description            = "Scrapes JIRA and publishes events into RockPaperScissors."
  lambda_runtime                = "python2.7"
  lambda_timeout                = "30"
  aws_region                    = "${var.aws_region}"
  lambda_vpc_subnet_ids         = "${var.subnet_ids}"
  lambda_vpc_security_group_ids = "${var.security_groups}"
}

resource "aws_cloudwatch_event_rule" "jira_scraper_event_rule" {
  name                = "${var.name}-${var.environment}-jira"
  description         = "Periodically run the RockPaperScissors JIRA scraper"
  schedule_expression = "rate(1 hour)"
}

resource "aws_cloudwatch_event_target" "jira_scraper_event_target" {
  target_id = "${var.name}-${var.environment}-jira"
  rule      = "${aws_cloudwatch_event_rule.jira_scraper_event_rule.name}"
  arn       = "${module.jira_scraper_lambda_app.arn}"
}

resource "aws_lambda_permission" "jira_scraper_event_target" {
  statement_id  = "AllowExecutionFromCloudWatch"
  action        = "lambda:InvokeFunction"
  function_name = "${var.name}-${var.environment}-jira"
  principal     = "events.amazonaws.com"
  source_arn    = "${aws_cloudwatch_event_rule.jira_scraper_event_rule.arn}"
}
