variable "name" {
  default = "rockpaperscissors"
}

variable "environment" {
  default = "production"
}

variable "owner" {
  default = "dta@twitch.tv"
}

variable "project" {
  default = "dta/rockpaperscissors"
}

variable "instance_type" {
  default = "t2.micro"
}

variable "subnet_ids" {
  default = "subnet-ebcd859c,subnet-23b19b46,subnet-c543209c"
}

variable "security_groups" {
  default = "sg-09387e6d,sg-4d3b7d29"
}

variable "account_id" {
  default = "043714768218"
}

variable "projects_table_read_capacity" {
  default = 10
}

variable "projects_table_write_capacity" {
  default = 5
}

variable "events_table_read_capacity" {
  default = 500
}

variable "events_table_write_capacity" {
  default = 15
}

variable "eventtype_gsi_read_capacity" {
  default = 1000
}

variable "eventtype_gsi_write_capacity" {
  default = 15
}

variable "disabled_metrics" {
  default = "avg_pull_request_open_time,num_pull_requests_open"
}

data "terraform_remote_state" "beanstalk_app" {
  backend = "s3"

  config {
    bucket = "tw-devtools"
    key    = "tfstate/dta/rockpaperscissors/terraform/beanstalk_app"
  }
}

module "rockpaperscissors_staging_env" {
  source                    = "../modules/rockpaperscissors-env"
  name                      = "${var.name}"
  owner                     = "${var.owner}"
  project                   = "${var.project}"
  eb_application_name       = "${var.name}"
  instance_type             = "${var.instance_type}"
  environment               = "staging"
  events_table_name         = "${module.rockpaperscissors_datastores.events_table_name}"
  events_table_arn          = "${module.rockpaperscissors_datastores.events_table_arn}"
  projects_table_name       = "${module.rockpaperscissors_datastores.projects_table_name}"
  projects_table_arn        = "${module.rockpaperscissors_datastores.projects_table_arn}"
  sandstorm_role_arn        = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/devtools-production-rockpaperscissors"
  ingest_queue_name         = "${module.rockpaperscissors_datastores.ingest_queue_name}"
  ingest_queue_arn          = "${module.rockpaperscissors_datastores.ingest_queue_arn}"
  vpc_id                    = "vpc-0184df64"
  subnet_ids                = "${var.subnet_ids}"
  security_groups           = "${var.security_groups}"
  github_webhook_url        = "${module.rockpaperscissors_github_handler.webhook_url}"
  memcached_config_endpoint = "${module.rockpaperscissors_datastores.memcached_configuration_endpoint}"
  disabled_metrics          = "${var.disabled_metrics}"
}

module "rockpaperscissors_deploy_env" {
  source                    = "../modules/rockpaperscissors-env"
  name                      = "${var.name}"
  owner                     = "${var.owner}"
  project                   = "${var.project}"
  eb_application_name       = "${var.name}"
  instance_type             = "${var.instance_type}"
  environment               = "${var.environment}"
  events_table_name         = "${module.rockpaperscissors_datastores.events_table_name}"
  events_table_arn          = "${module.rockpaperscissors_datastores.events_table_arn}"
  projects_table_name       = "${module.rockpaperscissors_datastores.projects_table_name}"
  projects_table_arn        = "${module.rockpaperscissors_datastores.projects_table_arn}"
  sandstorm_role_arn        = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/devtools-production-rockpaperscissors"
  ingest_queue_name         = "${module.rockpaperscissors_datastores.ingest_queue_name}"
  ingest_queue_arn          = "${module.rockpaperscissors_datastores.ingest_queue_arn}"
  vpc_id                    = "vpc-0184df64"
  subnet_ids                = "${var.subnet_ids}"
  security_groups           = "${var.security_groups}"
  github_webhook_url        = "${module.rockpaperscissors_github_handler.webhook_url}"
  notification_email        = "rps-team@twitch.tv"
  rollbar_token             = "6d514565627e4bf796840d9e47c9d40f"
  memcached_config_endpoint = "${module.rockpaperscissors_datastores.memcached_configuration_endpoint}"
  disabled_metrics          = "${var.disabled_metrics}"
}

module "rockpaperscissors_datastores" {
  source                        = "../modules/rockpaperscissors-datastores"
  name                          = "${var.name}"
  project                       = "${var.project}"
  owner                         = "${var.owner}"
  environment                   = "${var.environment}"
  subnet_ids                    = "${var.subnet_ids}"
  security_groups               = "${var.security_groups}"
  account_id                    = "${var.account_id}"
  projects_table_read_capacity  = "${var.projects_table_read_capacity}"
  projects_table_write_capacity = "${var.projects_table_write_capacity}"
  events_table_read_capacity    = "${var.events_table_read_capacity}"
  events_table_write_capacity   = "${var.events_table_write_capacity}"
  eventtype_gsi_read_capacity   = "${var.eventtype_gsi_read_capacity}"
  eventtype_gsi_write_capacity  = "${var.eventtype_gsi_write_capacity}"
  memcached_cluster_name        = "rps-prod"                                # rockpaperscissors-production is too long
}

module "rockpaperscissors_github_handler" {
  source                                 = "../modules/rockpaperscissors-github-handler"
  name                                   = "${var.name}"
  project                                = "${var.project}"
  owner                                  = "${var.owner}"
  environment                            = "${var.environment}"
  event_stream_arn                       = "${module.rockpaperscissors_datastores.event_stream_arn}"
  subnet_ids                             = "${var.subnet_ids}"
  security_groups                        = "${var.security_groups}"
  github_webhook_handler_rest_api_id     = "${data.terraform_remote_state.beanstalk_app.github_webhook_handler_rest_api_id}"
  github_webhook_handler_deployment_name = "${data.terraform_remote_state.beanstalk_app.github_webhook_handler_deployment_name}"
  github_webhook_handler_resource_id     = "${data.terraform_remote_state.beanstalk_app.github_webhook_handler_resource_id}"
  account_id                             = "${var.account_id}"
  large_events_s3_bucket_arn             = "${module.rockpaperscissors_datastores.s3_bucket_arn}"
}

module "rockpaperscissors_blueprint_ingest" {
  source           = "../modules/rockpaperscissors-blueprint-ingest"
  name             = "${var.name}"
  project          = "${var.project}"
  owner            = "${var.owner}"
  environment      = "${var.environment}"
  event_stream_arn = "${module.rockpaperscissors_datastores.event_stream_arn}"
  ingest_queue_arn = "${module.rockpaperscissors_datastores.ingest_queue_arn}"
  subnet_ids       = "${var.subnet_ids}"
  security_groups  = "${var.security_groups}"
  account_id       = "${var.account_id}"
}

module "rockpaperscissors_github_stats" {
  source           = "../modules/rockpaperscissors-github-stats"
  name             = "${var.name}"
  project          = "${var.project}"
  owner            = "${var.owner}"
  environment      = "${var.environment}"
  event_stream_arn = "${module.rockpaperscissors_datastores.event_stream_arn}"
  ingest_queue_arn = "${module.rockpaperscissors_datastores.ingest_queue_arn}"
  subnet_ids       = "${var.subnet_ids}"
  security_groups  = "${var.security_groups}"
  account_id       = "${var.account_id}"
}

module "rockpaperscissors_jira_scraper" {
  source             = "../modules/rockpaperscissors-jira-scraper"
  name               = "${var.name}"
  project            = "${var.project}"
  owner              = "${var.owner}"
  environment        = "${var.environment}"
  event_stream_arn   = "${module.rockpaperscissors_datastores.event_stream_arn}"
  sandstorm_role_arn = "arn:aws:iam::734326455073:role/sandstorm/production/templated/role/devtools-production-rockpaperscissors"
  subnet_ids         = "${var.subnet_ids}"
  security_groups    = "${var.security_groups}"
  account_id         = "${var.account_id}"
}

module "rockpaperscissors_alerts" {
  source                        = "../modules/rockpaperscissors-alerts"
  name                          = "${var.name}"
  environment                   = "${var.environment}"
  pagerduty_endpoint            = "https://events.pagerduty.com/integration/48e15407bb1f46d7bd989a4945c442f1/enqueue"
  kinesis_stream_name           = "${module.rockpaperscissors_datastores.event_stream_name}"
  event_store_lambda_name       = "${module.rockpaperscissors_datastores.event_store_lambda_name}"
  blueprint_ingest_lambda_name  = "${module.rockpaperscissors_blueprint_ingest.lambda_function_name}"
  github_stats_lambda_name      = "${module.rockpaperscissors_github_stats.lambda_function_name}"
  jira_scraper_lambda_name      = "${module.rockpaperscissors_jira_scraper.lambda_function_name}"
  github_webhook_lambda_name    = "${module.rockpaperscissors_github_handler.lambda_function_name}"
  worker_queue_name             = "${module.rockpaperscissors_datastores.ingest_queue_name}"
  eb_environment_name           = "${module.rockpaperscissors_deploy_env.beanstalk_environment_name}"
  github_webhook_api_name       = "${data.terraform_remote_state.beanstalk_app.github_webhook_handler_rest_api_name}"
  github_webhook_stage_name     = "${data.terraform_remote_state.beanstalk_app.github_webhook_handler_deployment_name}"
  events_table_name             = "${module.rockpaperscissors_datastores.events_table_name}"
  projects_table_name           = "${module.rockpaperscissors_datastores.projects_table_name}"
  projects_table_read_capacity  = "${var.projects_table_read_capacity}"
  projects_table_write_capacity = "${var.projects_table_write_capacity}"
  events_table_read_capacity    = "${var.events_table_read_capacity}"
  events_table_write_capacity   = "${var.events_table_write_capacity}"
  eventtype_gsi_read_capacity   = "${var.eventtype_gsi_read_capacity}"
  eventtype_gsi_write_capacity  = "${var.eventtype_gsi_write_capacity}"
}
