package euls

type noopClient struct{}

// NewNoopClient returns a Client that doesn't send metrics. This is useful if
// you want to provide your users a way to opt out of sending metrics while not
// having two code paths through your code. If users opt out, use this Client
// implementation the rest of your code doesn't need to change.
func NewNoopClient(config *Config) (Client, error) {
	return &noopClient{}, nil
}

func (c *noopClient) StartSession() error { return nil }

func (c *noopClient) StopSession() error { return nil }

func (c *noopClient) PutEvent(eventType string, attributes map[string]*string, metrics map[string]*float64) error {
	return nil
}
