package euls

import "runtime"

// ClientContext describes the client.
type ClientContext struct {
	ClientID       string `json:"client_id"`
	AppTitle       string `json:"app_title"`
	AppVersionName string `json:"app_version_name"`
	AppVersionCode string `json:"app_version_code"`
	AppPackageName string `json:"app_package_code"`
}

// EnvContext describes the environment.
// See https://docs.aws.amazon.com/mobileanalytics/latest/ug/PutEvents.html for valid values.
type EnvContext struct {
	Platform        string `json:"platform"`
	Model           string `json:"model"`
	Make            string `json:"make"`
	PlatformVersion string `json:"platform_version"`
	Locale          string `json:"locale"`
}

// DefaultEnvContext creates an EnvContext with golang runtime information.
// It is the recommended EnvContext.
func DefaultEnvContext() EnvContext {
	platform := runtime.GOOS
	switch platform {
	case "darwin":
		platform = "macos"
	}

	return EnvContext{
		Platform:        platform,
		PlatformVersion: runtime.Version(),
	}
}

// Context is the Client Context header used in Mobile Analytics requests.
type Context struct {
	Client   ClientContext `json:"client"`
	Env      EnvContext    `json:"env"`
	Services struct {
		MobileAnalytics struct {
			AppID string `json:"app_id"`
		} `json:"mobile_analytics"`
	} `json:"services"`
}
