package euls

import (
	"log"
	"os"
)

var logger Logger = log.New(os.Stderr, "", log.LstdFlags)

// Logger is subset of golang standard logger we use.
type Logger interface {
	Print(args ...interface{})
	Printf(format string, args ...interface{})
	Println(args ...interface{})
}

// SetLogger sets the logger that is used.
// Isn't mutex protected so only call from init() functions.
func SetLogger(l Logger) {
	logger = l
}
