# Deploy Proxy
**TERRAFORM VERSION: 0.8.4**
This is the Terraform for the deploy proxy service. 

**GOAL:** Build a proxy service that will help offload network traffic going across the twitch backbone and twitch proxies

The Terraform will build the following:
* ELB
* 2 Instances 
* VPC Endpoint
* S3 Bucket
* S3 Bucket Object
* S3 Bucket Policy (Allowing only the VPC Endpoint)

**GIT Repos:**
* [ng_devtools_proxy_git] - This is the repo where any nginx changes should be made
* [tf_deployProxy] - This repo

**BUILDS:** 
* [ng-devtools-proxy-build]
* [ng-devtools-proxy-deploy]

**DEPLOYMENT:** 
* [ng_devtools_proxy] 
* Deployment is handled via a courier docker container Deployment.

**Steps to deploy an updated container:**
* Ensure that there is a development instance for you to test (you will need this in a later step)
* Create a branch with your changes on github in this repo: [ng_devtools_proxy_git]
* An autobuild will occur once you push your changes up to your branch.
* Go to Skadi [ng_devtools_proxy] and deploy your branch to the `development` environment.
* Make sure all changes work as expected
* Make a PR and send to team in `#dta-priv`
* Once the PR is approved merge your changes to `master`
* An autobuild should kick off again for the master branch automatically
* Go to Skadi [ng_devtools_proxy] and deploy to `production`


**Required Variables:**

|Variable|Sample Values|
|:-------------------------------|:-----|
|instance_count                 |1|
|owner                          |dta@justin.tv|
|environment                    |development|
|env                            |dev|
|sub_env                        |dta|
|aws_region                     |us-west-2|

Regions are specified by the tfvars files

**NOTE:** This only builds the part of the deploy proxy service that resides in AWS, the nodes that do the most caching are located in the POPs.
[ng-devtools-proxy-build]: https://jenkins.internal.justin.tv/job/ng-devtools-proxy-build/
[ng-devtools-proxy-deploy]: https://jenkins.internal.justin.tv/job/ng-devtools-proxy-deploy/
[ng_devtools_proxy]: https://clean-deploy.internal.justin.tv/#/dta/ng_devtools_proxy
[tf_deployProxy]: https://git-aws.internal.justin.tv/dta/tf_deployProxy
[ng_devtools_proxy_git]: https://git-aws.internal.justin.tv/dta/ng_devtools_proxy


