job {
  name 'devtools-httpchecker-build'
  using 'TEMPLATE-autobuild'
  scm {
    git {
      remote {
        github 'dta/tf_datadogagent', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
    }
  }
  steps {
    shell 'docker build --build-arg api_key=$DTA_DATADOG_API_KEY -t datadog-httpchecker:$GIT_COMMIT . ; docker tag datadog-httpchecker:$GIT_COMMIT docker.internal.justin.tv/devtools/datadog-httpchecker:$GIT_COMMIT; docker push docker.internal.justin.tv/devtools/datadog-httpchecker:$GIT_COMMIT'
  }
}

job {
  name 'devtools-httpchecker-deploy'
  using 'TEMPLATE-deploy-aws'
  steps {
    shell 'courier deploy --hosts $HOSTS --environment $ENVIRONMENT --repo "dta/tf_datadogagent" --image "docker.internal.justin.tv/devtools/datadog-httpchecker"'
  }
}
