#!/bin/bash
exec > >(tee /var/log/user-data.log|logger -t user-data -s 2>/dev/console) 2>&1
mac_addr=$(ifconfig | awk '/ens/ { print $5 }')
subnetid=$(curl -s http://169.254.169.254/latest/meta-data/network/interfaces/macs/$mac_addr/subnet-id)
ip_address=$(curl -s http://169.254.169.254/latest/meta-data/local-ipv4)
ec2_hostname=$(curl -s http://169.254.169.254/latest/meta-data/local-hostname)
codename=$(cat /etc/*ease | grep -i ubuntu_codename | sed 's/=/ /' | awk '{ print $2 }')
dist=$(cat /etc/*ease | grep DISTRIB_CODENAME | sed -e 's/=/ /' | awk '{ print $2 }')
az=$(curl -s http://169.254.169.254/latest/meta-data/placement/availability-zone)
monit_service='docker'
mkdir -p /opt/docker/etc
mkdir -p /etc/sandstorm/{conf.d,templates.d}
mkdir -p /etc/consul.d
mkdir -p /repos
echo "deb [arch=amd64] http://packages.internal.justin.tv/internal/twitch trusty main" > /etc/apt/sources.list.d/twitch.list
echo "Update Packages"
apt-get update -y
echo "Installing Sandstorm"
apt-get install sandstorm -y
echo "Installing docker daemon"
apt-get remove lxc-docker -y
apt-get install docker.io -y
apt-get install jq -y
apt-get install consul -y
DD_API_KEY=a879c49ab54e15c821dcd3fc0958daf8 bash -c "$(curl -L https://raw.githubusercontent.com/DataDog/dd-agent/master/packaging/datadog-agent/source/install_agent.sh)"
useradd docker -g docker
cat <<- EOF > /etc/dd-agent/conf.d/docker_daemon.yaml
init_config:
instances:
    - url: "unix://var/run/docker.sock"
EOF
cat <<- EOF > /etc/consul.d/main.json
  {"advertise_addr":"$ip_address","bind_addr":"0.0.0.0","data_dir":"/var/lib/consul","datacenter":"us-west2","disable_remote_exec":true,"disable_update_check":true,"enable_syslog":true,"node_name":"$ec2_hostname","ports":{"serf_lan":8306},"server":false,"start_join":["consul-server-0.prod.us-west2.justin.tv","consul-server-1.prod.us-west2.justin.tv","consul-server-2.prod.us-west2.justin.tv","consul-server-3.prod.us-west2.justin.tv","consul-server-4.prod.us-west2.justin.tv"],"statsd_addr":"graphite.internal.justin.tv:8125","syslog_facility":"local3"}
EOF
cat <<- EOF > /etc/consul.d/datadog-httpchecker.json
  {"service":{"check":{},"id":"datadog-httpchecker","name":"datadog-httpchecker","port":80,"tags":["${full_env_name}"]}}
EOF
cat <<- EOF > /etc/consul.d/service_nodeinfo.json
  {"service":{"check":{},"id":"nodeinfo","name":"nodeinfo","port":0,"tags":["fqdn=$ec2_hostname","lsbdistcodename=$dist"]}}
EOF
cat <<- EOF > /etc/monit/conf.d/$monit_service
check process $monit_service with pidfile /var/run/docker.pid 
  start program = "/bin/bash -c 'service docker start" with timeout 10 seconds
  stop program  = "/bin/bash -c 'service docker stop'" with timeout 10 seconds
EOF
cat <<- 'EOF' > /etc/init/consul.conf
description "Consul agent"

start on runlevel [2345]
stop on runlevel [!2345]

respawn

script
  # Make sure to use all our CPUs, because Consul can block a scheduler thread
  export GOMAXPROCS=`nproc`

  # Get the public IP
  BIND=`ifconfig eth0 | grep "inet addr" | awk '{ print substr($2,6) }'`

  exec /usr/bin/consul agent \
    -config-dir="/etc/consul.d" \
    -bind=$BIND \
    >>/var/log/consul.log 2>&1
end script
EOF
service consul restart
/usr/sbin/service monit stop
/usr/sbin/service monit start
service datadog-agent restart
