module "tf_asg_stack" "nginx_stack" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/dta/tf_asg_stack.git?ref=1.0.4"

  owner                           = "${var.owner}"
  iam_roles                       = "${var.iam_role}"
  ec2_ami                         = "${data.aws_ami.trusty.id}"
  ec2_key_name                    = "${var.ec2_key_name}"
  ec2_subnet_ids                  = "${var.subnet_ids}"
  ec2_user_data                   = "${data.template_file.user-data.rendered}"
  ec2_instance_type               = "${var.ec2_instance_type}"
  ec2_vpc_security_group_ids      = "${null_resource.enviro.triggers.security_group},${aws_security_group.allow_all_outbound.id}"
  elb_security_group_ids          = "${null_resource.enviro.triggers.security_group},${aws_security_group.allow_all_outbound.id}"
  elb_subnet_ids                  = "${null_resource.enviro.triggers.subnet_ids}"
  r53_zone_id                     = "${var.r53_zone_id}"
  vpc_id                          = "${null_resource.enviro.triggers.vpc_id}"
  service_name                    = "${var.service_name}"
  env                             = "${var.env}"
  sub_env                         = "${var.sub_env}"
  aws_region                      = "${var.aws_region}"
  elb_listener_instance_port      = "${var.elb_listener_instance_port}"
  elb_listener_instance_protocol  = "${var.elb_listener_instance_protocol}"
  elb_listener_ssl_certificate_id = "${data.terraform_remote_state.internal_cert.arn}"
  elb_listener_lb_port            = "${var.elb_listener_lb_port}"
  elb_listener_lb_protocol        = "${var.elb_listener_lb_protocol}"
  elb_hcheck_path                 = "/_healthcheck"
  elb_hcheck_target               = "HTTP:80/_healthcheck"
  elb_hcheck_interval             = "${var.hcheck_interval}"
  elb_hcheck_timeout              = "${var.hcheck_timeout}"
  tag_owner                       = "${var.tag_owner}"
  tag_service                     = "${var.tag_service}"
  aws_access_key                  = "${var.aws_access_key}"
  aws_secret_key                  = "${var.aws_secret_key}"
  r53_aws_access_key              = "${var.r53_aws_access_key}"
  r53_aws_secret_key              = "${var.r53_aws_secret_key}"
  ec2_root_volume_size            = "${var.ec2_root_disk_size}"
  asg_health_check_type           = "${var.asg_hcheck_type}"
  asg_desired_capacity            = "${var.desired_capacity}"
  asg_max_size                    = "${var.max_size}"
  asg_min_size                    = "${var.min_size}"
}
