data "terraform_remote_state" "internal_cert" {
  backend = "s3"

  config {
    bucket = "tw-devtools"
    key    = "tfstate/dta/tf_devtools_team/certificates/internal_justin_tv"
  }
}

data "terraform_remote_state" "prod_vpc" {
  backend = "s3"

  config {
    bucket = "tw-devtools"
    key    = "tfstate/dta/tf_devtools_team/vpc/production"
  }
}

data "terraform_remote_state" "dev_vpc" {
  backend = "s3"

  config {
    bucket = "tw-devtools"
    key    = "tfstate/dta/tf_devtools_team/vpc/development"
  }
}

data "terraform_remote_state" "prod_twitch_subnets_sg" {
  backend = "s3"

  config {
    bucket = "tw-devtools"
    key    = "tfstate/dta/tf_devtools_team/security_groups/production/twitch_subnets"
  }
}

data "terraform_remote_state" "dev_twitch_subnets_sg" {
  backend = "s3"

  config {
    bucket = "tw-devtools"
    key    = "tfstate/dta/tf_devtools_team/security_groups/development/twitch_subnets"
  }
}

data "terraform_remote_state" "key_pair" {
  backend = "s3"

  config {
    bucket = "tw-devtools"
    key    = "tfstate/dta/tf_devtools_team/key_pairs/devtools_dta"
  }
}

data "terraform_remote_state" "twitch_aws" {
  backend = "s3"

  config {
    bucket = "tw-devtools"
    key    = "tfstate/dta/tf_devtools_team/account/twitch-aws"
  }
}

data "aws_ami" "trusty" {
  most_recent = true

  filter {
    name   = "name"
    values = ["devtools-baseami-trusty-1483572112"]
  }
}
