resource "null_resource" "vars" {
  triggers {
    cn = "${var.env}-${var.sub_env}-${var.service_name}"
  }
}

resource "null_resource" "enviro" {
  triggers {
    security_group = "${var.env == "prod" ? data.terraform_remote_state.prod_twitch_subnets_sg.sg_id : data.terraform_remote_state.dev_twitch_subnets_sg.sg_id}"
    subnet_ids = "${var.env == "prod" ? data.terraform_remote_state.prod_vpc.private_subnet_ids : data.terraform_remote_state.dev_vpc.private_subnet_ids}"
    vpc_id = "${var.env == "prod" ? data.terraform_remote_state.prod_vpc.vpc_id : data.terraform_remote_state.dev_vpc.vpc_id}"
  }
}

resource "null_resource" "region" {
  triggers {
    region = "${var.aws_region == "us-west-2" ? "" : ""}"
  }
}
