resource "aws_security_group" "allow_all_outbound" {
  name        = "${var.service_name}-${var.env}-allow-all-outbound"
  description = "Allow all outbound traffic from deploy proxy service"
  vpc_id      = "${null_resource.enviro.triggers.vpc_id}"

  egress {
    from_port   = 0
    to_port     = 0
    protocol    = "-1"
    cidr_blocks = ["0.0.0.0/0"]
  }

  tags {
    Name    = "${var.service_name}-allow-all-outbound"
    Owner   = "${var.owner}"
    Service = "devtools/${var.service_name}/service"
  }
}
