variable "aws_access_key" {
  default = ""
}

variable "aws_secret_key" {
  default = ""
}

variable "r53_aws_access_key" {
  default = ""
}

variable "r53_aws_secret_key" {
  default = ""
}

# Variables with defaults
variable "route_table_ids" {
  description = "route tables that belong to development environments"
  default     = "rtb-c889a1ad,rtb-4ab8af2f,rtb-55b8af30,rtb-4713f723"
}

variable "environment" {
  default = "dev"
}

variable "listen_port" {
  default = "80"
}

variable "default_storage" {
  description = "the default amount of storage for the mysql db in GB"
  default     = 100
}

variable "desired_capacity" {
  description = "how many nodes should we have"
  default     = 1
}

variable "max_size" {
  description = "the maximum size for the asg"
  default     = 2
}

variable "min_size" {
  description = "the minimum size for the asg"
  default     = 1
}

variable "asg_hcheck_type" {
  description = "Use either ELB or EC2"
  default     = "EC2"
}

variable "ec2_root_disk_size" {
  description = "default size of root disk"
  default     = 100
}

variable "tag_owner" {
  default = "dta@justin.tv"
}

variable "tag_service" {
  default = "devtools/datadogagent/service"
}

variable "r53_ttl" {
  default = "300"
}

variable "cross_zone_load_balancing" {
  description = "Enable load balancing across multiple availability zones"
  default     = "true"
}

variable "idle_timeout" {
  default = "60"
}

variable "internal_elb" {
  default     = "true"
  description = "determines if the ELB is internal or not - default is true"
}

variable "ec2_instance_type" {
  default = "m4.large"
}

variable "subnet_ids" {
  default = "subnet-bbce86cc,subnet-1fb69c7a,subnet-bf4221e6"
}

variable "iam_role" {
  default = "devtools-dev-datadogagent"
}

variable "hcheck_healthy_threshold" {
  description = "The number of checks before the instance is declared healthy"
  default     = "2"
}

variable "hcheck_unhealthy_threshold" {
  description = "The number of checks before the instance is declared unhealthy"
  default     = "3"
}

variable "docker_hcheck_path" {
  description = "The path of the check related to the docker nginx setup"
  default     = "/healthcheck"
}

variable "docker_hcheck_target" {
  description = "An override of the default ELB target should be generated to be HTTP:6500/healthcheck"
  default     = ""
}

variable "hcheck_interval" {
  default = "120"
}

variable "hcheck_timeout" {
  default = "60"
}

variable "security_group_ids" {
  default = "sg-708bc514,sg-b0703ed4"
}

variable "r53_aws_profile" {
  default = "twitch-aws"
}

variable "r53_zone_id" {
  default = "ZRG00SM48517Z"
}

variable "sandstorm_system_iam_rolearn" {
  default = "arn:aws:iam::043714768218:role/devtools-dev-datadogagent"
}

variable "elb_listener_instance_port" {
  default = "80"
}

variable "elb_listener_instance_protocol" {
  default = "HTTP"
}

variable "elb_listener_lb_port" {
  default = "443"
}

variable "elb_listener_lb_protocol" {
  default = "HTTPS"
}

variable "sandstorm_secret" {
  default = "devtools-dev-datadogagent"
}

variable "ec2_key_name" {
  default = "devtools-dta"
}

variable "full_env_name" {
  default = "development"
}

variable "aws_region" {
  default = "us-west-2"
}

variable "env" {
  default = "dev"
}

variable "sub_env" {
  default = "dta"
}

variable "service_name" {
  default = "datadogagent"
}

variable "s3_bucket_iam_user" {
  default = "datadogagent-prod"
}

variable "owner" {
  default = "dta@justin.tv"
}

variable "s3_account_id" {
  default = "043714768218"
}

#variable "ec2_ami" {
#  default = "ami-024bfb62"
#}

variable "vpc_id" {
  default = "vpc-c1496ea4"
}
