module "tf_tabot_elb" {

  source = "git::git+ssh://git@git-aws.internal.justin.tv/dta/tf_basic_ec2_stack.git?ref=2.0.1"

  aws_access_key = "${var.aws_access_key}"
  aws_secret_key = "${var.aws_secret_key}"
  aws_region = "${var.aws_region}"
  r53_aws_access_key = "${var.r53_aws_access_key}"
  r53_aws_secret_key = "${var.r53_aws_secret_key}"
  owner = "${var.owner}"
  tag_service = "${var.tag_service}"
  tag_env = "${var.tag_env}"

  service_name = "${var.service_name}"
  instance_count = "${var.instance_count}"

  ec2_ami = "${var.ec2_ami}"
  ec2_instance_type = "${var.ec2_instance_type}"
  ec2_instance_name = "${var.ec2_instance_name}"
  ec2_iam_instance_profile = "${aws_iam_instance_profile.tabot_prod.id}"
  ec2_subnet_id = "${var.ec2_subnet_id}" 
  ec2_vpc_security_group_ids = "${aws_security_group.tabot_ec2.id},${var.twitch_subnets_sgid}"
  ec2_user_data = "${file(var.ec2_user_data_file)}"

  ec2_r53_zone_id = "${var.ec2_r53_zone_id}"
  ec2_r53_type = "${var.ec2_r53_type}"
  ec2_r53_ttl = "${var.ec2_r53_ttl}"

  elb_name = "${var.elb_name}"
  elb_listener_instance_port = "${var.tabot_port}"
  elb_listener_instance_protocol = "${var.elb_listener_instance_protocol}"
  elb_listener_lb_port = "${var.elb_listener_lb_port}"
  elb_listener_lb_protocol = "${var.elb_listener_lb_protocol}"
  elb_security_groups = "${aws_security_group.tabot_elb.id}"
  elb_hcheck_healthy_threshold = "${var.elb_hcheck_healthy_threshold}"
  elb_hcheck_unhealthy_threshold = "${var.elb_hcheck_unhealthy_threshold}"
  elb_hcheck_health_interval = "${var.elb_hcheck_health_interval}"
  elb_hcheck_health_timeout = "${var.elb_hcheck_health_timeout}"
  elb_hcheck_health_target = "${concat("HTTP:",var.tabot_port,"/health")}"
  elb_subnets = "${var.subnet_ids}" 

  elb_r53_zone_id = "${var.elb_r53_zone_id}"
  elb_r53_type = "${var.elb_r53_type}"
  elb_r53_ttl = "${var.elb_r53_ttl}"
}

