# Shared variables

variable "aws_access_key" {
  description = "AWS Access key for user with IAM credentials"
}

variable "aws_secret_key" {
  description = "AWS Secret key for user with IAM credentials"
}

variable "aws_region" {
  description = "AWS region to operate in"
}

variable "r53_aws_access_key" {
  description = "Route53 AWS access key for IAM credentials"
}

variable "r53_aws_secret_key" {
  description = "Route53 AWS secret key for IAM credentials"
}

variable "tag_service" {
  description = "Special variable used only for AWS tag. All lower­case, in  team/service/[role] format. This tag should indicate the server’s function and what is running on it;  role is optional but highly recommended. #REQUIRED"
  default = "dta/tabot"
}

variable "owner" {
  description = "Special variable used only for AWS tag. The user or team who owns this infrastructure. Will be used for tagging AWS resources. Should be an email address. #REQUIRED"
  default = "devtools@twitch.tv"
}

variable "tag_env" {
  description = "Special variable used only for AWS tag. Must begin with one of the following:  dev (development),  stage (staging), or  prod (production). May include an optional subcategory."
  default = "prod"
}

variable "vpc_id" {
  default = "vpc-0184df64"
}

variable "subnet_ids" {
  default = "subnet-eacd859d,subnet-22b19b47"
}

# due to bug with subnet_id being blank and falling on vpc's default subnet instead of relying on ELBs subnet
variable "ec2_subnet_id" {
  default = "subnet-eacd859d"
}

variable "tabot_port" {
  default = 8080
}

variable "twitch_subnets_sgid" {
  default = "sg-09387e6d"
}

###############
# ELB and EC2 # 
###############

variable "service_name" {
  description = "The name of the service you are launching. Used to generate the route53 fqdns for ec2 instances and the elb. If you change this here, change it in the userdatafile as well"
  default = "tabot-prod"
}

variable "instance_count" {
  description = "The number of identical ec2 instances to create"
  default = 1
}

#######
# EC2 #
#######

variable "ec2_ami" {
  description = "The ami to launch the ec2 instances with"
  default = "ami-d76c90b7"
}

variable "ec2_instance_type" {
  description = "The type of ec2 instances to launch (ex: t2.medium)"
  default = "t2.medium"
}

variable "ec2_user_data_file" {
  description = "The path to the user data to provide when launching the instance"
  default = "userdatafile"
}

variable "ec2_instance_name" {
  description = "The value of the 'name' tag of the ec2 instances"
  default = "tabot-prod"
}

###########
# EC2 R53 #
###########

variable "ec2_r53_zone_id" {
  description = "The ID of the hosted zone to contain this record"
  default = "ZRG00SM48517Z"
}

variable "ec2_r53_type" {
  description = "The record type"
  default = "A"
}

variable "ec2_r53_ttl" {
  description = "(Required for non-alias records) The TTL of the record"
  default = "300"
}

#######
# ELB #
#######

variable "elb_name" {
  description = "The name for the ELB. Its 'name' tag will be assigned this value"
  default = "tabot-elb-prod"
}

variable "elb_listener_instance_protocol" {
  description = "The protocol to use to the instance. Valid values are HTTP, HTTPS, TCP, or SSL"
  default = "HTTP"
}

variable "elb_listener_lb_port" {
  description = "The port to listen on for the load balance"
  default = 80
}

variable "elb_listener_lb_protocol" {
  description = "The protocol to listen on. Valid values are HTTP, HTTPS, TCP, or SSL"
  default = "HTTP"
}

variable "elb_hcheck_healthy_threshold" {
  description = "The number of checks before the instance is declared healthy"
  default = 5 
}

variable "elb_hcheck_unhealthy_threshold" {
  description = "The number of checks before the instance is declared unhealthy"
  default = 10
}

variable "elb_hcheck_health_interval" {
  description = "The interval between checks"
  default = 60
}

variable "elb_hcheck_health_timeout" {
  description = "The length of time before the check times out"
  default = 10
}

###########
# ELB R53 #
###########

variable "elb_r53_zone_id" {
  description = "The ID of the hosted zone to contain this record"
  default = "ZRG00SM48517Z"
}

variable "elb_r53_type" {
  description = "The record type"
  default = "CNAME"
}

variable "elb_r53_ttl" {
  description = "(Required for non-alias records) The TTL of the record"
  default = "300"
}

#######
# IAM #
#######

variable "application_instance_name" {
  description = "Name of the Owner-Application-Environment"
  default = "dta-tabot-prod"
}

variable "keys_policy_file" {
  description = "path to the keys policy file in JSON"
  default = "keys_policy.json"
}

variable "iam_role_name" {
  description = "Name of the IAM role, policy and instance profile"
  default = "tabot-prod"
}

variable "iam_role_file" {
  description = "path to iam role json"
  default = "tabot_role.json"
}

variable "iam_policy_file" {
  description = "path to iam policy json"
  default = "tabot_policy.json"
}

