resource "aws_iam_role" "tabot_staging" {
  name = "${var.iam_role_name}"
  assume_role_policy = "${file(var.iam_role_file)}"
}

resource "aws_iam_role_policy" "tabot_staging" {
  name = "${var.iam_role_name}"
  role = "${aws_iam_role.tabot_staging.id}"
  policy = "${file(var.iam_policy_file)}"
}

resource "aws_iam_instance_profile" "tabot_staging" {
  name = "${var.iam_role_name}"
  roles = ["${aws_iam_role.tabot_staging.name}"]
}

resource "aws_iam_role_policy" "keys_tabot_staging" {
  name = "keys-${var.application_instance_name}"
  role = "${aws_iam_role.tabot_staging.id}"
  policy = "${file(var.keys_policy_file)}"
}
