# Accounts

This outlines how to use TCS with a new AWS account. AWS profiles and terraform
remote states need to be configured properly for TCS to work with your AWS account.

## Configuration

TCS needs to be configured with environments, AWS profiles, and terraform information.
TCS chooses configuration based on the org flag. Organization configuration is
currently in code.

```go
// internal/bootstrap/bootstrap.go L33
var AWSAccounts = map[string]map[string]string{
// web is the name of the org
	"web": {
// production and staging are the only environments and are required.
		"production": "twitch-web-aws",
		"staging":    "twitch-web-dev",
	},
	"video": {
		"production": "twitch-video-aws",
		"staging":    "twitch-video-aws",
	},
}

var TerraformSubnetListName = map[string]string{
	"web":   "service_subnets",
	"video": "production_subnets",
}
```

Environments is a mapping of environment names to AWS profiles. TerraformSubnetListName is the
subents key name in terraform remote state.

Add your org with the corresponding values to each `AWSAccounts` and `TerraformSubnetListName`
and send a pull request.

## AWS Requirements

The following AWS privileges should be enabled for the account you are using:

```none
iam:CreateRole
iam:DeleteRole
iam:GetRole
iam:PassRole
iam:CreateInstanceProfile
iam:ListInstanceProfilesForRole
iam:GetInstanceProfile
iam:DeleteInstanceProfile
iam:AddRoleToInstanceProfile
iam:RemoveRoleFromInstanceProfile

SNS:CreateTopic
SNS:DeleteTopic
SNS:GetTopicAttributes
SNS:Subscribe
SNS:Unsubscribe
SNS:GetSubscriptionAttributes
```

## Terraform requirements

The terraform currently assumes that the following remote state paths are configured.
The bucket name used is the name of the AWS account. The region is us-west-2.
You will likely need to manually create the following terraform remote state files.
Below each terraform remote state description is a template you can use to upload
to s3.

`tfstate/_org_/terraform/accounts/_environment_`:

- `output.twitch_subnets_sg`: Security groups
- `output._TerraformSubnetListName_`: Subnets

Find your security groups and subnets and fill them in the template below. Upload
the template to s3 path above.

```json
{
    "version": 1,
    "serial": 1,
    "remote": {
        "type": "s3",
        "config": {
            "bucket": "_account_",
            "key": "tfstate/_org_/terraform/accounts/_account_"
        }
    },
    "modules": [
        {
            "path": [
                "root"
            ],
            "outputs": {
                "twitch_subnets_sg": "",
                "_TerraformSubnetListName_": ""
            }
        }
    ]
}
```

`tfstate/_org_/asg-r53-lambda/services/lambda/_environment_`:

- `output.asg_lambda_arn`: Lambda ARN

You use [asg-r53-lambda](https://git-aws.internal.justin.tv/dta/asg-r53-lambda)
to provision the necessary resources in your AWS account. Copy
an existing account directory and name it after your account. Replace the old account name
with yours as well as the account number. Then run `terraform apply`. Terraform will output
`asg_lambda_arn`, copy and paste that that value into the template and upload to the
above path. Note that org in the s3 key path is hardcoded to "web". TCS has this hard coded
and it will stay like that until further notice to avoid breaking current accounts.

```json
{
    "version": 1,
    "serial": 1,
    "remote": {
        "type": "s3",
        "config": {
            "bucket": "_account_",
            "key": "tfstate/web/asg-r53-lambda/services/lambda/_account_"
        }
    },
    "modules": [
        {
            "path": [
                "root"
            ],
            "outputs": {
                "asg_lambda_arn": ""
            }
        }
    ]
}
```
