package structs

import "github.com/google/go-github/github"

type AppType interface {
	SetClient(*github.Client, *github.Repository, bool)
	PreflightCheck() error
	MakeUsable() error
	MakeBuildable() error
	CreateApp(string, string, string) error
	CreatePuppetModule() error
	CreateTerraformFiles(string, string, map[string]string, string) error
}

type PuppetModuleTemplate struct {
	PuppetModuleName string
	Name             string
	FullName         string
}

type TerraformTemplate struct {
	PuppetModuleName        string
	Name                    string
	FullName                string
	User                    string
	DNSSafeName             string
	Environment             string
	AWSAccounts             map[string]string
	Org                     string
	TerraformSubnetListName string
}
