package terraform

import (
	"io/ioutil"
	"testing"
)

func TestIncrementCounts(t *testing.T) {
	body, err := loadVariableFile("testdata/service_orig.tf")
	if err != nil {
		t.Fatalf("error loading variable file: %v", err)
	}

	body, err = incrementCounts(body)
	if err != nil {
		t.Fatal(err)
	}

	compareFiles(t, body, "testdata/service_golden.tf")
}

func compareFiles(t *testing.T, orig, path string) {
	golden, err := ioutil.ReadFile(path)
	if err != nil {
		t.Fatal(err)
	}

	if orig != string(golden) {
		t.Fatalf("hcl did not match expected: %v", orig)
	}
}
