# logstash-beater

Writes logstash messages quickly via [libbeat](https://github.com/elastic/beats) and tells you how it's doing.

## Running

`go run main.go -c logstash-beater.yml`

## Configuring

Create `logstash-beater.yaml`:

```yaml
---
input:
  rate: 10000
  just_go_fast: true

output:
  logstash:
    hosts:
      - syslog-stasher-752128b2.dev.us-west2.justin.tv:5045
      - syslog-stasher-bef7e279.dev.us-west2.justin.tv:5044
    loadbalance: true
```

### Input options

`rate` - The rate to attempt to send messages at per second. At quicker rates, you'll probably
start slowing down a bit, but that's fine.

`rate_warning_threshold` - An integer, represents the percentage difference between
desired message rate (configured above) and actual message rate at which to alert
you that messaging is slow.

`just_go_fast` - Binary, when set to true, the options above are ignored, and
it just Goes Fast. Will report every second on how many messages were sent, and
after 10 seconds, will start reporting average rates.

### Output options

Output can be anything supported by libbeat. See the [filebeat configuration options](https://www.elastic.co/guide/en/beats/filebeat/current/filebeat-configuration-details.html) for details.

The use case this app was created for is for testing against logstash, but
there's no reason you couldn't use this for testing file logging or something.
