/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.scanner.cli;

import java.util.Properties;
import org.sonarsource.scanner.api.EmbeddedScanner;
import org.sonarsource.scanner.api.LogOutput;
import org.sonarsource.scanner.cli.Logs;
import org.sonarsource.scanner.cli.ScannerVersion;

class ScannerFactory {
    private final Logs logger;

    public ScannerFactory(Logs logger) {
        this.logger = logger;
    }

    EmbeddedScanner create(Properties props) {
        return EmbeddedScanner.create("ScannerCli", ScannerVersion.version(), new DefaultLogOutput()).addGlobalProperties(props);
    }

    class DefaultLogOutput
    implements LogOutput {
        DefaultLogOutput() {
        }

        @Override
        public void log(String formattedMessage, LogOutput.Level level) {
            switch (level) {
                case TRACE: 
                case DEBUG: {
                    ScannerFactory.this.logger.debug(formattedMessage);
                    break;
                }
                case ERROR: {
                    ScannerFactory.this.logger.error(formattedMessage);
                    break;
                }
                case WARN: {
                    ScannerFactory.this.logger.warn(formattedMessage);
                    break;
                }
                default: {
                    ScannerFactory.this.logger.info(formattedMessage);
                }
            }
        }
    }
}

