package main

import "math/rand"
import "os"
import "time"
import "fmt"
import "path/filepath"
import "io/ioutil"

func init() {
	rand.Seed(time.Now().UnixNano())
}

var letterRunes = []rune("abcdefghijklmnopqrstuvwxyz")

func generateString(n int) string {
	b := make([]rune, n)
	for i := range b {
		b[i] = letterRunes[rand.Intn(len(letterRunes))]
	}
	return string(b)
}

func removeDirectory(parent string) {
	_, err := os.Stat(parent)
	if err == nil {
		os.RemoveAll(parent)
	}
	return
}

/*
currently pretty clunky, but works for testing so far,
will need to make structure more complex to cover edge cases

createDirectory creates directory structures as follows:
- outermost file is named $parent
- number of folders in $parent is = layer1
- " " layer 2
= " " layer 3
- each folder in layer 3 contains 1 text file (will be changed)
*/
func createDirectory(parent string, layer1 int, layer2 int, layer3 int) {
	//check if fake directory already exists, remove if it does
	_, err := os.Stat(parent)
	if err == nil {
		os.RemoveAll(parent)
	}

	//create simple tree structure
	for i := 0; i < layer1; i++ {
		word1 := generateString(4)
		os.MkdirAll(parent+"/"+word1, 0700)
		for j := 0; j < layer2; j++ {
			word2 := generateString(3)
			os.MkdirAll(filepath.Join(parent, word1, word2), 0700)
			for k := 0; k < layer3; k++ {
				word3 := generateString(2)
				word4 := generateString(10)
				os.MkdirAll(filepath.Join(parent, word1, word2, word3), 0700)
				f, err := os.Create(filepath.Join(parent, word1, word2, word3, word4+".txt"))
				info, err := f.Stat()
				ioutil.WriteFile(filepath.Join(parent, word1, word2, word3, word4+".txt"), []byte("Hi, this is some text!\n"), 0666)
				n := rand.Intn(2)
				if n == 0 {
					err = os.Chtimes(filepath.Join(parent, word1, word2, word3, word4+".txt"), info.ModTime().AddDate(-1, 0, 0), info.ModTime().AddDate(-1, 0, 0))
					if err != nil {
						fmt.Println("Couldn't change mod time.")
						fmt.Println(err)
					}
				}
			}
		}

	}
}
