job {
  name 'availability-buckytools-package'
  using 'TEMPLATE-autobuild'
  scm {
    git {
      remote {
        github 'availability/buckytools', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
    }
  }
  steps {
    shell 'mkdir -p fpm_source_xenial/usr/bin'
    shell 'manta -v -f build.json && mv .manta/* fpm_source_xenial/usr/bin/ && mkdir -p output'
    fpmPackageFromDir('deb', 'fpm_source_xenial')
    shell 'mv buckytools_*_amd64.deb output/buckytools.deb'
    saveDeployArtifact('availability/buckytools', 'output')
  }
}


job {
  name 'availability-buckytools-package-artifactory'
  using 'TEMPLATE-deploy'
  scm {
    git {
      remote {
        github 'availability/buckytools', 'ssh', 'git.xarth.tv'
        credentials 'git-aws-read-key'
      }
    }
  }
  parameters {
    stringParam 'GIT_COMMIT'
  }
  steps {
    downloadDeployArtifact 'availability/buckytools'
    uploadDeb('buckytools.deb', 'xenial')
  }
  wrappers {
    preBuildCleanup()
  }
}
