# c2g-collector

AWS Lambda function to collect resources that exist, as reported from capacity management's inventory Redshift database. It runs every minute.

This function sends collected resources downstream to a [scraper lambda](https://git-aws.internal.justin.tv/availability/c2g-scraper), which polls the last minute of CloudWatch data and submits relevant metrics.


## Adding an Account to Scrape

* Talk to capacity planning to add an account to their [ETL job](https://git-aws.internal.justin.tv/systems/capacity-planning/blob/master/scripts/etl/elbETL.py)
* Ensure that the account being added has the proper IAM role setup in their account
	- IAM role called `inventory-read-only`, which has full read-only access to their account
	- The above role must trust at least the `inventory-read-only` role in `twitch-central-aws`, or even the entire `twitch-central-aws` account
* Keep an eye on the CloudWatch log stream to ensure that the new account is not causing any errors, permission or otherwise


## Development Lifecycle

### Terraform

Because this is a TCS project, the Terraform for this project lives directly in this repository, rather than `systems/systems-terraform`. Make changes directly in `terraform/` for the proper environment. Apply changes by running the appropriate `./scripts/terraform_*.sh` script.

### Code Changes

Standard Twitch deployment tooling is set up for this Lambda. It can be deployed via [clean-deploy](http://clean-deploy.internal.justin.tv/#/availability/c2g-collector)

### Monitoring

Coming soon

### Testing

Coming soon
