import os

prod_catalog = "http://status.internal.justin.tv/api/v1"
staging_catalog = "http://status-development.internal.justin.tv/api/v1"


# Returns the service catalog endpoint 
# based on the environment
def get_catalog_endpoint():
    try:
        env = os.environ["environment"]
        if env == "production":
            endpoint = prod_catalog
        elif env == "staging":
            endpoint = staging_catalog
        else:
            raise NameError("no such environment '{env}'".format(env=env))
    except KeyError:
        endpoint = get_catalog_endpoint_from_env_vars()
    return endpoint


def get_catalog_endpoint_from_env_vars():
    # Get required params
    try:
        endpoint = os.environ['CATALOG_ENDPOINT']
    except KeyError:
        # Custom error message
        raise NameError("must define either a valid 'environment' or 'CATALOG_ENDPOINT'")

    return endpoint
