import os

prod_db = "capacity-prod.capxk4j4th11.us-west-2.redshift.amazonaws.com"
staging_db = "cp-perf.cgbyqpej1fq9.us-west-2.redshift.amazonaws.com"


# Returns the db connection info in the following tuple:
# (host, port, db_name)
def get_db_info():
    try:
        env = os.environ["environment"]
        if env == "production":
            info = (prod_db, 5439, "capacity")
        elif env == "staging":
            info = (staging_db, 5439, "capacity")
        else:
            raise NameError("no such environment '{env}'".format(env=env))
    except KeyError:
        info = get_db_info_from_env_vars()
    return info


def get_db_info_from_env_vars():
    # Get required params
    try:
        db_name = os.environ['REDSHIFT_DB_NAME']
        db_host = os.environ['REDSHIFT_DB_HOST']
    except KeyError:
        # Custom error message
        raise NameError("must define either a valid 'environment' or both 'REDSHIFT_DB_NAME' and 'REDSHIFT_DB_HOST'")

    # Get the port (optional, defaults to 5439)
    try:
        db_port = int(os.environ['REDSHIFT_DB_PORT'])
    except KeyError:
        db_port = 5439

    return (db_host, db_port, db_name)
