import unittest
from mock import patch
import os
import db


class CredsTest(unittest.TestCase):

    def test_get_db_info_env(self):
        with patch.dict(os.environ, {'environment': 'production'}, clear=True):
            host, port, name = db.get_db_info()
            assert host == "capacity-prod.capxk4j4th11.us-west-2.redshift.amazonaws.com"
            assert port == 5439
            assert name == "capacity"
        with patch.dict(os.environ, {'environment': 'staging'}, clear=True):
            host, port, name = db.get_db_info()
            assert host == "cp-perf.cgbyqpej1fq9.us-west-2.redshift.amazonaws.com"
            assert port == 5439
            assert name == "capacity"
        with patch.dict(os.environ, {'environment': 'notexist'}, clear=True):
            try:
                host, port, name = db.get_db_info()
                raise AssertionError("should throw an error when the specified environment does not exist")
            except NameError:
                # Expected
                pass

    def test_get_db_info_manual(self):
        with patch.dict(os.environ, {'REDSHIFT_DB_NAME': 'foobar',
                                     'REDSHIFT_DB_PORT': '1234',
                                     'REDSHIFT_DB_HOST': 'www.db.com'}, clear=True):
            host, port, name = db.get_db_info()
            assert host == "www.db.com"
            assert port == 1234
            assert name == "foobar"
