job {
  name 'availability-c2g-collector-create'
  using 'TEMPLATE-autobuild'
  scm {
    git {
      remote {
        github 'availability/c2g-collector', 'ssh', 'git-aws.internal.justin.tv'
        credentials 'git-aws-read-key'
      }
    }
  }
  steps {
    shell "rm -rf .manta/"
    shell "manta -v"
    saveLambdaFunction "availability/c2g-collector", ".manta"
  }
}

job {
  name 'availability-c2g-collector-prod-deploy'
  using 'TEMPLATE-lambda-deploy'
  steps {
    deployLambdaFunction "availability/c2g-collector", "availability-c2g-collector-\$ENVIRONMENT", "\$ENVIRONMENT"
  }
  wrappers {
    credentialsBinding {
      file('AWS_CONFIG_FILE', 'aws_config')
      file('AWS_UPLOADER_CONFIG_FILE', 'twitch-central-aws-lambda-deploy')
    }
  }
}

job {
  name 'availability-c2g-collector-staging-deploy'
  using 'TEMPLATE-lambda-deploy'
  steps {
    deployLambdaFunction "availability/c2g-collector", "availability-c2g-collector-\$ENVIRONMENT", "\$ENVIRONMENT"
  }
  wrappers {
    credentialsBinding {
      file('AWS_CONFIG_FILE', 'aws_config')
      file('AWS_UPLOADER_CONFIG_FILE', 'twitch-central-dev-lambda-deploy')
    }
  }
}

