# SNS Topic for the ELB
resource "aws_sns_topic" "lambda_alert_sns" {
  provider = "aws.twitch-central-aws"
  name = "availability-c2g-collector-production"
}

# Subscribe PagerDuty to the SNS Topic
resource "aws_sns_topic_subscription" "pagerduty_sns_subscription" {
  provider = "aws.twitch-central-aws"
  topic_arn = "${aws_sns_topic.lambda_alert_sns.arn}"
  protocol = "https"
  endpoint = "https://events.pagerduty.com/integration/0ca002d01dee49cfa2aee0df8e534f57/enqueue" # Availability - High prio queue
  endpoint_auto_confirms = true
}

# Create an alarm for when the lambda isnt triggered periodically
resource "aws_cloudwatch_metric_alarm" "lambda_invocation_alarm" {
  provider = "aws.twitch-central-aws"
  alarm_name = "availability-c2g-collector-production-invocation-count"
  comparison_operator = "LessThanThreshold"
  evaluation_periods = "5"
  metric_name = "Invocations"
  namespace = "AWS/Lambda"
  period = "60"
  statistic = "Sum"
  threshold = "1"
  alarm_description = "Triggered when the Lambda stops getting run once per minute"
  alarm_actions = ["${aws_sns_topic.lambda_alert_sns.arn}"]
  ok_actions = ["${aws_sns_topic.lambda_alert_sns.arn}"]
  dimensions {
    FunctionName = "availability-c2g-collector-production"
  }
}

# Create an alarm for when the lambda throws errors
resource "aws_cloudwatch_metric_alarm" "lambda_error_alarm" {
  provider = "aws.twitch-central-aws"
  alarm_name = "availability-c2g-collector-production-error-count"
  comparison_operator = "GreaterThanThreshold"
  evaluation_periods = "5"
  metric_name = "Errors"
  namespace = "AWS/Lambda"
  period = "60"
  statistic = "Sum"
  threshold = "0"
  alarm_description = "Triggered when the Lambda errors repeatedly"
  alarm_actions = ["${aws_sns_topic.lambda_alert_sns.arn}"]
  ok_actions = ["${aws_sns_topic.lambda_alert_sns.arn}"]
  dimensions {
    FunctionName = "availability-c2g-collector-production"
  }
}
