import unittest
from mock import patch
from datetime import datetime
import run
import pprint

class BatchTest(unittest.TestCase):

    # Ensure that process_records sends 10 resource batches
    def test_process_records_batching(self):
        with patch('run.flush', return_value=None) as flush_mock:
            # our 'resources' dont need to do anything for this test,
            # just be iterable
            t = datetime.now()
            resources1 = list(range(24))
            run.process_resources(resources1, t)
            assert flush_mock.call_count == 3
            resources1 = list(range(50))
            run.process_resources(resources1, t)
            assert flush_mock.call_count == 3 + 5


class TimestampTest(unittest.TestCase):

    def test_truncate_timestmap(self):
        t1 = run.truncate_timestamp("2017-03-01T23:07:43-08:00")
        assert t1 == "2017-03-01T23:07:00-08:00"

class ComponentDictTest(unittest.TestCase):
    def test_elb_to_dict(self):
        comp = {"label":"elb:twitch-chat-aws:zuma-production:us-west-2","type":"elb","account":1}
        comp_dict = run.component_to_dict(comp)
        assert comp_dict['type'] == "elb"
        assert comp_dict['elbname'] == 'zuma-production'
        assert comp_dict['awsaccountname'] == "twitch-chat-aws"
        assert comp_dict['awsregion'] == 'us-west-2'

    def test_beanstalk_to_dict(self):
        comp = {"label":"beanstalk:twitch-passport:passport:us-west-2","type":"beanstalk","account":1}
        comp_dict = run.component_to_dict(comp)
        assert comp_dict['type'] == "beanstalk"
        assert comp_dict['applicationname'] == 'passport'
        assert comp_dict['awsaccountname'] == "twitch-passport"
        assert comp_dict['awsregion'] == 'us-west-2'

    def test_alb_to_dict(self):
        comp = {"label":"alb:twitch-web-aws:alb-internal-nginx-api:us-west-2","type":"alb","account":1}
        comp_dict = run.component_to_dict(comp)
        assert comp_dict['type'] == "alb"
        assert comp_dict['albname'] == 'alb-internal-nginx-api'
        assert comp_dict['awsaccountname'] == "twitch-web-aws"
        assert comp_dict['awsregion'] == 'us-west-2'

    def test_visage_to_dict(self):
        comp = {"label":"visage:Audrey","type":"visageClient","account":0}
        comp_dict = run.component_to_dict(comp)
        assert comp_dict == None
