# c2g-scraper

AWS Lambda function that receives a list of AWS resources to scrape, and pulls the last minute of CloudWatch data and injects it into Graphite.

## Where the Data Goes

All data scraped by `c2g-scraper` gets dumped into Graphite with the following naming scheme:
* ELBs
	- `cloudwatch.<aws_account>.<region>.<elb_name>.<metric_name>`
* Beanstalk Applications
	- `cloudwatch.<aws_account>.<region>.<beanstalk_app_name>.<elb_name>.<metric_name>`

## How Scrape Tasks are Generated

This Lambda is initiated by [c2g-collector](https://git-aws.internal.justin.tv/availability/c2g-collector), which reads a series of Redshift tables to determine which AWS resources will be scraped. Resources from these tables are batched and sent as the payload to this lambda function.


## Development Lifecycle

### Terraform

Because this is a TCS project, the Terraform for this project lives directly in this repository, rather than `systems/systems-terraform`. Make changes directly in `terraform/` for the proper environment. Apply changes by running the appropriate `./scripts/terraform_*.sh` script.

### Code Changes

Standard Twitch deployment tooling is set up for this Lambda. It can be deployed via [clean-deploy](http://clean-deploy.internal.justin.tv/#/availability/c2g-scraper)

### Monitoring

Coming soon

### Testing

Coming soon