
module "tf_lambda_app" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/dta/tf_lambda_app.git?ref=1.6.0"
  aws_region = "${var.aws_region}"
  aws_profile = "twitch-central-aws"
  owner = "availability-team@twitch.tv"
  repository = "availability/c2g-scraper"
  environment = "production"
  lambda_handler = "run.lambda_handler"
  lambda_function_name = "availability-c2g-scraper-production"
  lambda_timeout = "180"
  lambda_description = "Scrape a series of CloudWatch metrics and submit the data into Graphite"
  lambda_runtime = "python2.7"
  
  lambda_policy = "${file("../../files/lambda_policy.json")}"
  principal = "007917851548"
  lambda_vpc_subnet_ids = "subnet-1a87f07e,subnet-0eb83678,subnet-828650da"
  lambda_vpc_security_group_ids = "sg-1825527e"
}

provider "aws" {
    alias   = "twitch-central-aws"
    profile = "twitch-central-aws"
    region  = "us-west-2"
}

resource "aws_iam_role_policy_attachment" "inventory_access" {
    provider = "aws.twitch-central-aws"
    role = "${module.tf_lambda_app.role_id}"
    policy_arn = "arn:aws:iam::007917851548:policy/inventory-assume-role"
}

resource "aws_elasticache_subnet_group" "c2g_describe_production_subnets"{
    name = "prod-c2g-describe-subnets"
    description = "subnets for c2g-describe redis"
    subnet_ids = ["subnet-1a87f07e","subnet-0eb83678","subnet-828650da"]
}

resource "aws_elasticache_cluster" "c2g_describe_production" {
  cluster_id           = "c2g-describe-prod"
  engine               = "redis"
  node_type            = "cache.m3.large"
  port                 = 6379
  num_cache_nodes      = 1
  parameter_group_name = "default.redis3.2"
  subnet_group_name    = "prod-c2g-describe-subnets"
  security_group_ids   = ["sg-1825527e"]
}
