
module "tf_lambda_app" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/dta/tf_lambda_app.git?ref=1.6.0"
  aws_region = "${var.aws_region}"
  aws_profile = "twitch-central-dev"
  owner = "availability-team@twitch.tv"
  repository = "availability/c2g-scraper"
  environment = "staging"
  lambda_handler = "run.lambda_handler"
  lambda_function_name = "availability-c2g-scraper-staging"
  lambda_timeout = "120"
  lambda_description = "Scrape a series of CloudWatch metrics and submit the data into Graphite"
  lambda_runtime = "python2.7"
  
  lambda_policy = "${file("../../files/lambda_policy.json")}"
  principal = "386434559102"
  lambda_vpc_subnet_ids = "subnet-071c4763,subnet-42e99934,subnet-3e41f266"
  lambda_vpc_security_group_ids = "sg-e55f4f83"
}

resource "aws_elasticache_subnet_group" "c2g_describe_staging_subnets"{
    name = "staging-c2g-describe-subnets"
    description = "subnets for c2g-describe redis"
    subnet_ids = ["subnet-071c4763","subnet-42e99934","subnet-3e41f266"]
}

resource "aws_elasticache_cluster" "c2g_describe_staging" {
  cluster_id           = "c2g-describe-staging"
  engine               = "redis"
  node_type            = "cache.m3.medium"
  port                 = 6379
  num_cache_nodes      = 1
  parameter_group_name = "default.redis3.2"
  subnet_group_name    = "staging-c2g-describe-subnets"
  security_group_ids   = ["sg-e55f4f83"]
}
