terraform {
  backend "s3" {
    bucket  = "twitch-central-aws"
    key     = "tfstate/availability/carbonapi/terraform/privatelink/terraform.tfstate"
    region  = "us-west-2"
    profile = "twitch-central-aws"
  }
}

provider "aws" {
  profile = "twitch-central-aws"
  alias   = "twitch-central-aws"
  region  = "us-west-2"
}

module "privatelink" {
  source = "git::git+ssh://git@git-aws.internal.justin.tv/terraform-modules/privatelink-alb.git?ref=v0.0.3"

  lb_port     = "80"
  account     = "twitch-central-aws"
  service     = "graphite-api"
  environment = "production"
  dns_name    = "carbonapi-eb-production.us-west-2.elasticbeanstalk.com"
  vpc         = "vpc-bda8eed9"                                           // Production in twitch-central-aws
  subnets     = ["subnet-1a87f07e", "subnet-0eb83678"]                   // subnets the load balancer is in.
}
