module "bs-monitor-production" {
  source                           = "../modules/tf_beanstalk_webserver_env"
  aws_profile                      = "twitch-central-aws"
  aws_region                       = "us-west-2"
  eb_application_name              = "${module.bs-app-production.beanstalk_application_name}"
  vpc_id                           = "vpc-bda8eed9"
  ec2_subnet_ids                   = "subnet-1a87f07e,subnet-0eb83678"
  elb_subnet_ids                   = "subnet-1a87f07e,subnet-0eb83678"
  elb_loadbalancer_security_groups = "sg-1825527e"
  auto_scaling_lc_security_groups  = "sg-1825527e"
  solution_stack_name              = "64bit Amazon Linux 2017.09 v2.8.4 running Docker 17.09.1-ce"
  auto_scaling_lc_instance_type    = "m4.2xlarge"
  owner                            = "availability@twitch.tv"
  service                          = "availability/carbonapi"
  env                              = "monitor-prod"
  associate_public_address         = "false"
  cname_prefix                     = "carbonapi-monitor-eb-production"
}

module "elb-health-checks" {
  source                        = "../modules/http-elb-healthchecks"
  account                       = "twitch-central-aws"
  pagerduty_cloudwatch_endpoint = "https://events.pagerduty.com/integration/2f2d5e1738e5438ca016edb671c19bdd/enqueue"
  elb_name                      = "${module.bs-monitor-production.load_balancers[0]}"
  rate_5xx_threshold            = "50"
  latency_threshold             = "5000"
  healthy_backend_threshold     = "4"
  evaluation_periods            = "3"
  check_period                  = "60"
  region                        = "us-west-2"
}
