module "bs-monitor-staging" {
  source                           = "../modules/tf_beanstalk_webserver_env"
  aws_profile                      = "twitch-central-dev"
  aws_region                       = "us-west-2"
  eb_application_name              = "${module.bs-app-staging.beanstalk_application_name}"
  vpc_id                           = "vpc-a19ca9c5"
  ec2_subnet_ids                   = "subnet-071c4763,subnet-42e99934"
  elb_subnet_ids                   = "subnet-071c4763,subnet-42e99934"
  elb_loadbalancer_security_groups = "sg-e55f4f83"
  auto_scaling_lc_security_groups  = "sg-e55f4f83"
  solution_stack_name              = "64bit Amazon Linux 2017.09 v2.8.4 running Docker 17.09.1-ce"
  auto_scaling_lc_instance_type    = "m4.large"
  owner                            = "availability@twitch.tv"
  service                          = "availability/carbonapi"
  env                              = "monitor-staging"
  associate_public_address         = "false"
  cname_prefix                     = "carbonapi-monitor-eb-staging"
}
