angular.module('graphite.controllers', [])
.controller('GraphiteController', ['GraphiteService', '$location', '$log', '$document', '$scope',
    function(GraphiteService, $location, $log, $document, $scope) {
        var self = this;
        self.node = GraphiteService.node;

        self.query = {
            limit: 25,
            page: 1
        };

        $log.debug("Loading Graphite controller");
        // initialize param if it isnt set
        $log.debug($location.search().path);
        if ($location.search().path == null) {
            $location.search({'path': ''});
        }

        // If a user hits Back, for example, reload the tree to reflect
        // the change to the URL
        $scope.$on('$locationChangeSuccess', GraphiteService.locationChange);

        $document.ready(function() {
            self.node.select($location.search().path);
            $log.debug(self.node);
        });
    }
])
.controller('GraphiteDialogController', ['GraphiteService', 'GraphiteDialogService',
    function(GraphiteService, GraphiteDialogService) {
        var self = this;
        self.data = GraphiteService.data;
        self.node = GraphiteService.node
        self.dialog = GraphiteService.dialog;

        // Close the dialog
        self.cancel = GraphiteDialogService.cancel;

        /* Metrics */
        // Move a metric
        self.moveMetric = GraphiteService.moveMetric;
    }
]);

