angular.module('graphite.service', [])
.service('GraphiteService', ['$http', '$mdDialog', '$q', '$location', '$log', 
    function($http, $mdDialog, $q, $location, $log) {
    var self = this;

    // dialog popups
    self.dialog = {};

    self.node = {
        'path': "",
        'children': [],
        'order': 'id',
        'filteredChildren': []
    };

    self.data = {
        move: {
            src: '',
            dst: ''
        }
    };

    self.node.changePath = function(path) {
        var url = self.getExpandPathURL(path);
        return $http.get(url)
        .then(
            function(result){
                var results = result.data.results;
                var sortedResult = results.sort(
                    function(a, b) {
                        if (a.leaf == 0 && b.leaf == 1) {
                            return -1;
                        } else if (a.leaf == 1 && b.leaf == 0) {
                            return 1;
                        } else {
                            return (a.id < b.id) ? -1 : ((a.id > b.id) ? 1 : 0);
                        }
                    }
                );
                // Change state
                self.node.path = path;
                self.node.children = sortedResult;
                // Change URL `path` param
                $location.search({'path': self.node.path});
                return sortedResult;
            }
        );
    };

    self.node.select = function(id) {
        $log.debug("changing nodes to: " + id);
        $log.debug("current filteredChildren:");
        $log.debug(self.node.filteredChildren);
        var path = "";
        if (self.node.path == "") {
            if (id == "") {
                path = "";
            } else {
                path = id;
            }
        } else {
            path = self.node.path + "." + id;
        }
        var children = self.node.changePath(path);
    };

    self.node.delete = function(id) {
        $log.debug("deleting: " + id);
        var url = self.getDeleteMetricURL(id);
        $http.delete(url)
        .then(
            function (result) {
                // Change state of the children, removing
                // the deleted metric
                self.node.children = self.node.children.filter(
                    function(child) {
                        return child.id != id;
                    }
                );
            }
        );
    };

    self.getDeleteMetricURL = function(path) {
        var url = '/graphite/metric?path=' + path;
        return url
    };

    self.getExpandPathURL = function(path) {
        var url = '/graphite/path/expand?path=' + path;

        return url;
    };

    self.node.isLeaf = function(child) {
        return child.leaf != 0;
    };

    self.locationChange = function() {
        var search = $location.search();
        if (search.path != self.node.path) {
            self.node.changePath(search.path);
        };
    };

    // Returns an object with `bucket` and `name`,
    self.splitMetricPath = function(metric) {
        var pathNodes = metric.split(".");
        var pathLength = pathNodes.length - 1;
        return {
            bucket: pathNodes.slice(0, pathLength-1).join("."), // everything but the last node
            name: pathNodes[pathLength-1] // the last node
        }
    }

   // Move metric to destination
    self.moveMetric = function() {
        //self.data.isLoading = true;

        var src = self.data.move.src;
        var dst = self.data.move.dst;
        var endpoint = '/graphite/metric/' + src + '/move/' + dst;

        $http.put(endpoint)
        .then(function(success) {
            var metric = success.data.data.dst;
            var metricComponents = self.splitMetricPath(metric);
            var bucket = metricComponents.bucket;
            var name = metricComponents.name;
            // Create a child node to attach to the current state (maybe)
            var child = {
                text: name,
                id: metric,
                leaf: 1,
                allowChildren: 0,
                staleness: 0
            }

            // If the newly moved metric is in the currently viewed bucket, add it to the children
            if (self.node.path === bucket) {
                // Existing secret; Update secret in the secrets array
                self.node.children.push(child);
            }

            GraphiteService.dialog.confirmDialog('Successfully Moved Metric', success.data.data.src + ' has been copied to ' + success.data.data.dst + '.', 'Move Another', 'Close')
            .then(function() {
                // Show move dialog again
                GraphiteService.dialog.moveDialog(src, null);
            }, function() {
                // Canceled
            });
        }, function(error) {
            GraphiteService.dialog.confirmDialog('Error Moving Metric', error.data.errors[0].detail, 'Go Back', 'Cancel')
            .then(function() {
                // Show move dialog again
                GraphiteService.dialog.moveDialog(src, dst);
            }, function() {
                // Canceled
            });
        });
    };

}]);