from flask import Blueprint, render_template, jsonify
from flask.ext.login import login_required
from flask import request
from app.graphite.models import *

graphite = Blueprint('graphite', __name__,
                  template_folder='templates',
                  static_folder='static')


# Use this to set the AngularJS module name
options = {'ng_app': 'dashboard.graphite'}


@graphite.route('')
@login_required
def home():
    return render_template('graphite/index.html',
                           title="Graphite",
                           options=options)

#########################
### UTILITY FUNCTIONS ###
#########################

def get_graphite_clusters():
    cluster_a = GraphiteCluster(DISCOVERY_A)
    cluster_b = GraphiteCluster(DISCOVERY_B)
    return cluster_a, cluster_b

#######################
###      API        ###
#######################

# Expands a non-leaf path and returns the nodes underneath it
@graphite.route('/path/expand')
@login_required
def path_expand():
    cluster_a, cluster_b = get_graphite_clusters()
    path = request.args.get("path")
    keys = cluster_a.list_children(path)
    return jsonify(results=keys)


# Someday in the future this should indicate staleness
# and give a 6h graph view or something if its active
# For now this route never gets hit
@graphite.route('/metric')
@login_required
def metric():
    cluster_a, cluster_b = get_graphite_clusters()
    path = request.args.get("path")
    

@graphite.route('/metric', methods=['DELETE'])
@login_required
def delete_metric():
    cluster_a, cluster_b = get_graphite_clusters()
    path = request.args.get("path")
    # Verify that the metric is a leaf
    info_a = cluster_a.get_metric_info(path)
    info_b = cluster_b.get_metric_info(path)
    if not info_a or not info_b or info_a['leaf'] != 1 or info_b['leaf'] != 1:
        returnjsonify({'error': 'given path is either not a valid metric; it is either a non-leaf or does not exist'}), 400
    cluster_a.delete_metric(path)
    cluster_b.delete_metric(path)
    return jsonify(info_a)
